/***************************************************************************
 *
 * Copyright (c) 2013,2014 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#ifndef CALIBRATION_H_INCLUDED
#define CALIBRATION_H_INCLUDED

#include <sys/types.h>

#include <string>
#include <iostream>

#include "CalibrationTypes.h"

namespace LayerManagerCalibration
{
    class Calibration
    {
    public:
        Calibration();
        virtual ~Calibration();
        bool parseFile(const std::string& fileName, bool store_param);
        bool write(std::ostream& os);
        void transformCoordinate(const coordinate& coordIn, coordinate& coordOut);
        bool inverseTransformCoordinate(const coordinate& coordIn, coordinate& coordOut);
        static bool calculateCoefficients(const coordinate& measured1,
                                          const coordinate& measured2,
                                          const coordinate& measured3,
                                          const coordinate& expected1,
                                          const coordinate& expected2,
                                          const coordinate& expected3,
                                          float& xCoefficientOne,
                                          float& xCoefficientTwo,
                                          float& xCoefficientThree,
                                          float& yCoefficientOne,
                                          float& yCoefficientTwo,
                                          float& yCoefficientThree);

        float& getXCoefficientOne();
        float& getXCoefficientTwo();
        float& getXCoefficientThree();
        float& getYCoefficientOne();
        float& getYCoefficientTwo();
        float& getYCoefficientThree();

    private:
        bool m_isValid;

        float m_fXCoefficientOne;
        float m_fXCoefficientTwo;
        float m_fXCoefficientThree;
        float m_fYCoefficientOne;
        float m_fYCoefficientTwo;
        float m_fYCoefficientThree;

    };

    inline Calibration::Calibration()
        : m_isValid(true),
          m_fXCoefficientOne(1.0),
          m_fXCoefficientTwo(0.0),
          m_fXCoefficientThree(0.0),
          m_fYCoefficientOne(0.0),
          m_fYCoefficientTwo(1.0),
          m_fYCoefficientThree(0.0)
    {
    }

    inline Calibration::~Calibration()
    {
    }

    inline float& Calibration::getXCoefficientOne()
    {
        return m_fXCoefficientOne;
    }

    inline float& Calibration::getXCoefficientTwo()
    {
        return m_fXCoefficientTwo;
    }

    inline float& Calibration::getXCoefficientThree()
    {
        return m_fXCoefficientThree;
    }

    inline float& Calibration::getYCoefficientOne()
    {
        return m_fYCoefficientOne;
    }

    inline float& Calibration::getYCoefficientTwo()
    {
        return m_fYCoefficientTwo;
    }

    inline float& Calibration::getYCoefficientThree()
    {
        return m_fYCoefficientThree;
    }

}

#endif // CALIBRATION_H_INCLUDED
